% This program simulates the model and runs an IV regressions to see the
% model counterpart of column (3) in table 8.
clear

load ../../'Estimation Results'/Benchmark_Model.mat

cd ./dynare_codes/

Model_Moments(parameters, N_variables, N_ll); % Used to save calibration
evalc('dynare World_Economy_Cartel_levels');

cd ../

%% Regressions of extraction rates on prices

X = oo_.endo_simul(1,:)';
X = [ones(length(X), 1), X];

theta_n = oo_.endo_simul(11,:)';

% First step is to compute the predicted world GDP
X_y = [ones(size(oo_.endo_simul, 2)-2, 1), oo_.endo_simul(16,1:end-2)', oo_.endo_simul(16,2:end-1)'];
Y_y = oo_.endo_simul(16,3:end)';
beta_y = X_y \ Y_y;
Y_predict = X_y * beta_y;
Z      = [ones(length(Y_predict), 1), Y_predict];

% Second, IV Regressions
% Now we can use the instrument to run the IV regression
X         = X(3:end,:);
beta_IV = (Z' * X) \ (Z' * theta_n(3:end));
disp(' ')
disp('IV regression - price elasticity of extraction rates:')
disp(['beta = ' num2str(beta_IV(2), '%.2f')])

